﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Promotion.PromoCode
{
    public partial class EditPromoCode : System.Web.UI.Page
    {
        private PromoCodes currPromoCode;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdPromoCodeID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowPromoCodeDetails();
                }
            }
        }

        private void ShowPromoCodeDetails()
        {
            currPromoCode = PromoCodesBL.GetItem(Guid.Parse(hdPromoCodeID.Value.Trim()), string.Empty, string.Empty);
            if (currPromoCode != null)
            {
                hdPromoCodeID.Value = currPromoCode.UniqueID.ToString();
                //ddlPromoType.SelectedIndex = ddlPromoType.Items.IndexOf(ddlPromoType.Items.FindByValue(currPromoCode.PromoType));
                txtPromoCode.Text = currPromoCode.PromoCode;
                ddlDiscountType.SelectedIndex = ddlDiscountType.Items.IndexOf(ddlDiscountType.Items.FindByValue(currPromoCode.DiscountType));
                txtDiscountValue.Text = currPromoCode.Discount.ToString("0.00");
                txtStartDate.Text = (currPromoCode.StartDate != DateTime.MinValue ? currPromoCode.StartDate.ToString("dd/MM/yyyy") : string.Empty);
                txtEndDate.Text = (currPromoCode.EndDate != DateTime.MinValue ? currPromoCode.EndDate.ToString("dd/MM/yyyy") : string.Empty);
                txtMaxUsage.Text = currPromoCode.AvailableUsage.ToString();
                txtPriceRangeFrom.Text = (currPromoCode.PriceRangeFrom > 0 ? currPromoCode.PriceRangeFrom.ToString("0.00") : string.Empty);
                txtPriceRangeTo.Text = (currPromoCode.PriceRangeTo > 0 ? currPromoCode.PriceRangeTo.ToString("0.00") : string.Empty);
                chkUseFromPrice.Checked = currPromoCode.UseFromPrice;
                chkIsActive.Checked = currPromoCode.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                currPromoCode = new PromoCodes();
                if (hdPromoCodeID.Value.Trim().Length == 0)
                    currPromoCode.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    currPromoCode.Mode = GlobalConfigurations.Mode.Update;
                    currPromoCode.UniqueID = Guid.Parse(hdPromoCodeID.Value.Trim());
                }

                //currPromoCode.PromoType = ddlPromoType.SelectedValue != "0" ? ddlPromoType.SelectedValue : string.Empty;
                currPromoCode.PromoCode = txtPromoCode.Text.Trim();
                currPromoCode.DiscountType = ddlDiscountType.SelectedValue != "0" ? ddlDiscountType.SelectedValue : string.Empty;
                currPromoCode.Discount = txtDiscountValue.Text.Trim().Length != 0 ? decimal.Parse(txtDiscountValue.Text.Trim()) : 0;
                currPromoCode.StartDate = (txtStartDate.Text.Trim().Length != 0 ? DateTime.ParseExact(txtStartDate.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue);
                currPromoCode.EndDate = (txtEndDate.Text.Trim().Length != 0 ? DateTime.ParseExact(txtEndDate.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue);
                currPromoCode.AvailableUsage = currPromoCode.MaxUsage = (txtMaxUsage.Text.Trim().Length != 0 ? int.Parse(txtMaxUsage.Text.Trim()) : 0);
                currPromoCode.PriceRangeFrom = (txtPriceRangeFrom.Text.Trim().Length != 0 ? decimal.Parse(txtPriceRangeFrom.Text.Trim()) : 0);
                currPromoCode.PriceRangeTo = (txtPriceRangeTo.Text.Trim().Length != 0 ? decimal.Parse(txtPriceRangeTo.Text.Trim()) : 0);
                currPromoCode.UseFromPrice = chkUseFromPrice.Checked;
                currPromoCode.IsActive = chkIsActive.Checked;
                currPromoCode.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (PromoCodesBL.Save(currPromoCode))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Promo Code details has been saved successfully.<br>Do you want to add another Promo Code?", this.ResolveClientUrl("~/Admin/Promotion/PromoCode/PromoCodeList.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Promotion/PromoCode/PromoCodeList.aspx", false);
        }

        private bool ValidatePageValue()
        {
            //if (ddlPromoType.SelectedValue.Equals("0"))
            //{
            //    WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + ddlPromoType.ClientID + "', 'Please select Salutation.');");
            //    return false;
            //}

            if (!ValidationUtility.ValidateString(txtPromoCode.Text.Trim()))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtPromoCode.ClientID + "', 'Please enter valid Promo Code.');");
                return false;
            }

            if (ddlDiscountType.SelectedValue.Equals("0"))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + ddlDiscountType.ClientID + "', 'Please select Discount Type.');");
                return false;
            }

            if (ValidationUtility.ValidateString(txtDiscountValue.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtDiscountValue.ClientID + "', 'Please enter Discount.');");
                    return false;
                }
            }

            if (!ValidationUtility.ValidateDate(txtStartDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtStartDate.ClientID + "', 'Please select Valid Start Date.');");
                return false;
            }

            if (!ValidationUtility.ValidateDate(txtEndDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtEndDate.ClientID + "', 'Please select Valid End Date.');");
                return false;
            }

            if (ValidationUtility.ValidateString(txtMaxUsage.Text.Trim()))
            {
                if (!ValidationUtility.ValidateInt(txtMaxUsage.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtMaxUsage.ClientID + "', 'Please enter valid Max Number of Use.');");
                    return false;
                }
            }

            if (ValidationUtility.ValidateString(txtPriceRangeFrom.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtPriceRangeFrom.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtPriceRangeFrom.ClientID + "', 'Please enter valid Price Range From.');");
                    return false;
                }
            }

            if (ValidationUtility.ValidateString(txtPriceRangeTo.Text.Trim()))
            {
                if (!ValidationUtility.ValidateDecimal(txtPriceRangeTo.Text.Trim()))
                {
                    WebUtilities.ShowValidationError(this, "validationMsgBottom('#" + txtPriceRangeTo.ClientID + "', 'Please enter valid Price Range To.');");
                    return false;
                }
            }

            return true;
        }
    }
}